<?php
namespace KitifyThemeBuilder\Modules\Woocommerce\Tags;

use KitifyThemeBuilder\Modules\Woocommerce\Module;
use KitifyThemeBuilder\Modules\Woocommerce\Tags\Traits\Tag_Product_Id;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class Product_Image extends Base_Data_Tag {
	use Tag_Product_Id;

	public function get_name() {
		return 'woocommerce-product-image-tag';
	}

	public function get_title() {
		return esc_html__( 'Product Image', 'kitify' );
	}

	protected function register_controls() {
		$this->add_product_id_control();
	}

	public function get_group() {
		return Module::WOOCOMMERCE_GROUP;
	}

	public function get_categories() {
		return [ \Elementor\Modules\DynamicTags\Module::IMAGE_CATEGORY ];
	}

	public function get_value( array $options = [] ) {
		$product = wc_get_product( $this->get_settings( 'product_id' ) );

		if ( ! $product ) {
			return [];
		}

		$image_id = $product->get_image_id();

		if ( ! $image_id ) {
			return [];
		}

		$src = wp_get_attachment_image_src( $image_id, 'full' );

		return [
			'id' => $image_id,
			'url' => $src[0],
		];
	}
}
